﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private StudentBL _StudentBL = null;

        public StudentBL Student
        {
            get
            {
                if (_StudentBL == null)
                {
                    _StudentBL = new StudentBL(this);
                }

                return _StudentBL;
            }
        }

        public class StudentBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            #region Student BL
            public StudentBL(ZSBELearning BL) : base(BL) { }

            public int Count()
            {
                return BLP.DAL.Student.Count();
            }

            public List<BO.Student> Restore()
            {
                return BLP.DAL.Student.Restore();
            }

            public List<BO.Student> Restore(ELearning.BL.BO.Student.Search Search)
            {
                return BLP.DAL.Student.Restore(Search);
            }

            public List<BO.Student> Restore(BO.Class Class)
            {
                ELearning.BL.BO.Student.Search _search = new BO.Student.Search();
                _search.ClassID = Class.ID;
                return BLP.DAL.Student.Restore(_search);
            }

            public List<BO.Student> Restore(BO.School School)
            {
                ELearning.BL.BO.Student.Search _search = new BO.Student.Search();
                _search.SchoolID = School.ID;
                return BLP.DAL.Student.Restore(_search);
            }

            public List<BO.Student> Restore(BO.Instructor Instructor)
            {
                ELearning.BL.BO.Student.Search _search = new BO.Student.Search();
                _search.InstructorID = Instructor.ID;
                return BLP.DAL.Student.Restore(_search);
            }

            public List<BO.Student> Restore(BO.SchoolYear SchoolYear)
            {
                ELearning.BL.BO.Student.Search _search = new BO.Student.Search();
                _search.SchoolYearID = SchoolYear.ID;
                return BLP.DAL.Student.Restore(_search);
            }

            public BO.Student Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
            {
                BO.Student _Student = null;

                if ((BO != null) && (BO.ID.HasValue))
                {
                    _Student = Restore(BO.ID);
                }

                return _Student;
            }

            public BL.BO.Student Restore(long? ID)
            {
                BL.BO.Student _Student = null;

                if (ID.HasValue)
                {
                    _Student = BLP.DAL.Student.Restore(ID);
                }

                return _Student;
            }

            public BL.BO.Student RestoreByUser(Gemini.Core.BL.Interface.BO.IUser User)
            {
                ELearning.BL.BO.Student.Search _search = new BO.Student.Search();
                _search.UserID = User.ID;
                return BLP.DAL.Student.RestoreTopOne(_search);
            }

            public Gemini.Core.BL.Base.MethodResult Save(BO.Student Student)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    if (Student == null)
                    {
                        _methodResult.SetSuccess = false;
                    }
                    else
                    {
                        ELearning.BL.BO.Student.Search _search = new BO.Student.Search();
                        _search.IndexNr = Student.IndexNr;
                        _search.ClassID = Student.ClassID;

                        BO.Student _indexStudent = BLP.DAL.Student.RestoreTopOne(_search);
                        if ((_indexStudent != null) && (_indexStudent.ID != Student.ID))
                        {
                            _methodResult.Add(String.Format(ELearning.BL.Dictionary.Text.Student.IndexAlreadyExist.Value, _indexStudent.IndexNr, _indexStudent.DisplayValue), false);
                        }         
                        else
                        {
                            PI.FM.N001.Account.BL.BO.View.User _checkUser = BLP.RBL.Account.User.View.RestoreByEmail(Student.Email);
                            if ((_checkUser != null) && (_checkUser.ID != Student.UserID))
                            {
                                _methodResult.Add(Gemini.Dictionary.Text.Email.AlreadyRegistered.Value, false);
                            }
                            else
                            {
                                if (!Gemini.Core.BL.Utility.Validate.IsValidEmail(Student.Email))
                                {
                                    _methodResult.Add(Gemini.Dictionary.Text.Email.NotValid.Value, false);
                                }
                            }

                            if (_methodResult.Success)
                            {
                                if (Student.ID.HasValue)
                                {
                                    #region Update
                                    _methodResult.SetSuccess = BLP.DAL.Student.Update(Student);

                                    if (_methodResult.Success)
                                    {
                                        PI.FM.N001.Account.BL.BO.User _user = BLP.RBL.Account.User.RestoreByID(Student.UserID);
                                        if (_user != null)
                                        {
                                            _user.Login = Student.Email;
                                            _user.Name = Student.Forename;
                                            _user.Surname = Student.Surename;
                                            if (!String.IsNullOrEmpty(Student.TmpPassword))
                                            {
                                                _user.Password = Student.TmpPassword;
                                            }

                                            _methodResult.Add(BLP.RBL.Account.User.Save(_user));

                                            if (_methodResult.Success)
                                            {
                                                Student.TmpPassword = _user.Password;
                                                BLP.APIEduFarma.SyncStudentSave(Student);
                                            }
                                        }
                                    }
                                    #endregion
                                }
                                else
                                {
                                    #region Create

                                    PI.FM.N001.Account.BL.BO.User _user = BLP.RBL.Account.User.New();
                                    _user.Flags = PI.FM.N001.Account.BL.BO.User.FlagsType.None;
                                    _user.GroupID = BLP.RBL.Account.Group.Restore(BLP.ClientID, (int)Dictionary.GroupType.Student).ID;
                                    _user.Email = Student.Email;
                                    _user.Name = Student.Forename;
                                    _user.Surname = Student.Surename;
                                    _user.ClientID = BLP.ClientID;
                                    _user.Password = Gemini.Utility.Text.GetRandomString(BLP.RBL.VariableRepository.GetInt(PI.FM.N001.Account.BL.Dictionary.Options.PasswordMinLength, BLP.RBL.Account.ClientID, Gemini.Dictionary.GlobalParams.MPasswordLength));
                                    if (BLP.RBL.Account.User.Save(_user).Success)
                                    {
#warning Wymienic na dedykowana metoda wysylania emaila;
                                        if (BLP.RBL.Account.User.BLP.User.EmailPassword(_user).Success)
                                        {
                                            List<BO.EvaluationSheet> _listEvaluationSheet = BLP.EvaluationSheet.Restore();

                                            Student.UserID = _user.ID;
                                            Student.TmpPassword = _user.Password;
                                            Student.CurrentEvaluationSheetID = _listEvaluationSheet[0].ID;
                                            _methodResult.SetSuccess = BLP.DAL.Student.Create(Student);

                                            if (_methodResult.Success)
                                            {
                                                BLP.APIEduFarma.SyncStudentAdd(Student);
                                            }
                                        }
                                        else
                                        {
                                            _methodResult.Add(String.Format(ELearning.BL.Dictionary.Text.Student.CreateFailedCauseEmail.Value, Student.Email), false);
                                        }
                                    }
                                    else
                                    {
                                        _methodResult.Add(String.Format(ELearning.BL.Dictionary.Text.Student.CreateFailedCauseEmail.Value, Student.Email), false);
                                    }
                                    #endregion

                                }
                            }
                        }
                    }               
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(String.Format(ELearning.BL.Dictionary.Text.Student.SaveFailed.Value,Student.DisplayValue,_exception));
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BO.Student Student)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                if (Student != null)
                {
                    try
                    {
                        _methodResult.Add(BLP.Statistic.Student.Remove(Student));
                        _methodResult.Add(BLP.StudentDoc.Remove(Student));
                        if (_methodResult.Success)
                        {
                            _methodResult.SetSuccess = BLP.DAL.Student.Remove(Student);

                            if ((_methodResult.Success) && (Student.UserID != null))
                            {
                                PI.FM.N001.Account.BL.BO.User _user = BLP.RBL.Account.User.RestoreByID(Student.UserID);
                                if (_user != null)
                                {
                                    BLP.APIEduFarma.SyncStudentDelete(Student);

                                    _methodResult.SetSuccess= BLP.BLELearning.Statistic.Course.Remove(_user);
                                    _methodResult.Add(BLP.RBL.Account.User.Remove(_user, BLP.ClientID));

                                }
                            }
                        }
                    }
                    catch (Exception _exeption)
                    {
                        _methodResult.Add(_exeption);
                    }
                }
                return _methodResult;
            }

            public Gemini.Core.BL.Base.MethodResult Delete()
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    BLP.DAL.Student_CompetencePart_Solution.Delete();
                    BLP.DAL.Student_CompetencePart.Delete();
                    BLP.DAL.Student_Competence.Delete();
                    BLP.DAL.StudentDoc.Delete();
                    BLP.DAL.Student.Delete();
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            public BL.BO.Student New()
            {
                return BLP.DAL.Student.New();
            }

            #endregion

            #region View
            private ViewBL _view = null;

            public ViewBL View
            {
                get
                {
                    if (_view == null)
                    {
                        _view = new ViewBL(this.BLP);
                    }
                    return _view;
                }
            }

            public class ViewBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>, Gemini.Core.BL.Interface.IBORestoreByID
            {
                public ViewBL(ZSBELearning BL) : base(BL) { }

                public List<BO.View.Student> Restore(BO.Student.Search Search)
                {
                    return BLP.DAL.StudentView.Restore(Search);
                }

                public Gemini.Core.BL.Interface.BO.IBaseUnique<long?> RestoreByID(long? ID)
                {
                    return BLP.DAL.StudentView.Restore(ID);
                }

                public BO.View.Student Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
                {
                    return BLP.DAL.StudentView.Restore(BO.ID);
                }

                public BO.View.Student RestoreById(long? ID)
                {
                    return BLP.DAL.StudentView.Restore(ID);
                }
            }
            #endregion
        }
    }
}
